/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.RollbackOnlyParticipant;
import com.atomikos.icatch.imp.SubTransactionCoordinatorParticipant;
import com.atomikos.icatch.imp.TxRollbackOnlyStateHandler;
import com.atomikos.icatch.imp.TxTerminatedStateHandler;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;

abstract class TransactionStateHandler
implements SubTxAwareParticipant {
    private int subtxs_;
    private Stack synchronizations_;
    private List subtxawares_;
    private CompositeTransactionImp ct_;

    protected TransactionStateHandler(CompositeTransactionImp compositeTransactionImp) {
        this.ct_ = compositeTransactionImp;
        this.subtxs_ = 0;
        this.subtxawares_ = new ArrayList();
        this.synchronizations_ = new Stack();
    }

    protected TransactionStateHandler(CompositeTransactionImp compositeTransactionImp, TransactionStateHandler transactionStateHandler) {
        this.subtxs_ = transactionStateHandler.getSubTransactionCount();
        this.synchronizations_ = transactionStateHandler.getSynchronizations();
        this.subtxawares_ = transactionStateHandler.getSubtxawares();
        this.ct_ = compositeTransactionImp;
    }

    protected synchronized CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        CompositeTransaction compositeTransaction = null;
        compositeTransaction = this.ct_.getTransactionService().createSubTransaction(this.ct_);
        compositeTransaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        ++this.subtxs_;
        return compositeTransaction;
    }

    protected RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        CoordinatorImp coordinatorImp = this.ct_.getCoordinatorImp();
        try {
            coordinatorImp.addParticipant(participant);
        }
        catch (RollbackException rollbackException) {
            throw new IllegalStateException("Transaction already rolled back");
        }
        return coordinatorImp;
    }

    protected synchronized void registerSynchronization(Synchronization synchronization) throws IllegalStateException, UnsupportedOperationException, SysException {
        if (synchronization != null) {
            try {
                this.ct_.getCoordinatorImp().registerSynchronization(synchronization);
            }
            catch (RollbackException rollbackException) {
                throw new IllegalStateException("Transaction already rolled back");
            }
            this.synchronizations_.push(synchronization);
        }
    }

    protected synchronized void addSubTxAwareParticipant(SubTxAwareParticipant subTxAwareParticipant) throws SysException, IllegalStateException {
        this.subtxawares_.add(subTxAwareParticipant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback() throws IllegalStateException, SysException {
        Stack<Throwable> stack = new Stack<Throwable>();
        TransactionStateHandler transactionStateHandler = this;
        synchronized (transactionStateHandler) {
            SubTxAwareParticipant subTxAwareParticipant;
            for (int i = 0; i < this.subtxawares_.size(); ++i) {
                subTxAwareParticipant = (SubTxAwareParticipant)this.subtxawares_.get(i);
                subTxAwareParticipant.rolledback((CompositeTransaction)this.ct_);
            }
            Enumeration enumeration = null;
            subTxAwareParticipant = this.ct_.getExtent();
            if (subTxAwareParticipant != null) {
                enumeration = subTxAwareParticipant.getParticipants().elements();
                while (enumeration.hasMoreElements()) {
                    Participant participant = (Participant)enumeration.nextElement();
                    this.addParticipant(participant);
                }
            }
            this.ct_.setTransactionStateHandler(new TxTerminatedStateHandler(this.ct_, this, false));
        }
        try {
            this.ct_.getCoordinatorImp().rollback();
        }
        catch (HeurCommitException heurCommitException) {
            stack.push(heurCommitException);
            throw new SysException("Unexpected error in rollback", stack);
        }
        catch (HeurMixedException heurMixedException) {
            stack.push(heurMixedException);
            throw new SysException("Unexpected error in rollback", stack);
        }
        catch (HeurHazardException heurHazardException) {
            stack.push(heurHazardException);
            throw new SysException("Unexpected error in rollback", stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit() throws SysException, IllegalStateException, RollbackException {
        Participant participant;
        Object object;
        Object var1_1 = null;
        Object var2_2 = null;
        if (this.ct_.isLocalRoot()) {
            this.ct_.getCoordinatorImp().addTag(this.ct_.tag_);
            object = this.ct_.getExtent().getParticipants().elements();
            while (object.hasMoreElements()) {
                participant = (Participant)object.nextElement();
                this.addParticipant(participant);
            }
        }
        object = this;
        synchronized (object) {
            if (this.subtxs_ > 0) {
                throw new IllegalStateException("active subtransactions exist");
            }
            participant = null;
            Enumeration enumeration = this.synchronizations_.elements();
            while (enumeration.hasMoreElements()) {
                participant = (Synchronization)enumeration.nextElement();
                participant.beforeCompletion();
            }
            if (this.ct_.getState().equals(TxState.MARKED_ABORT)) {
                this.rollback();
                throw new RollbackException("The transaction was set to rollback only");
            }
            for (int i = 0; i < this.subtxawares_.size(); ++i) {
                SubTxAwareParticipant subTxAwareParticipant = (SubTxAwareParticipant)this.subtxawares_.get(i);
                subTxAwareParticipant.committed((CompositeTransaction)this.ct_);
            }
            this.ct_.setTransactionStateHandler(new TxTerminatedStateHandler(this.ct_, this, true));
        }
    }

    protected synchronized void setRollbackOnly() {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage("Transaction.setRollbackOnly was called.");
        RollbackOnlyParticipant rollbackOnlyParticipant = new RollbackOnlyParticipant(stringHeuristicMessage);
        this.addParticipant(rollbackOnlyParticipant);
        this.ct_.setTransactionStateHandler(new TxRollbackOnlyStateHandler(this.ct_, this));
    }

    public synchronized void committed(CompositeTransaction compositeTransaction) {
        CompositeTransactionImp compositeTransactionImp = (CompositeTransactionImp)compositeTransaction;
        Extent extent = compositeTransaction.getTransactionControl().getExtent();
        Extent extent2 = this.ct_.getExtent();
        extent2.add(extent);
        SubTransactionCoordinatorParticipant subTransactionCoordinatorParticipant = new SubTransactionCoordinatorParticipant(compositeTransactionImp.getCoordinatorImp());
        this.addParticipant(subTransactionCoordinatorParticipant);
        --this.subtxs_;
    }

    public synchronized void rolledback(CompositeTransaction compositeTransaction) {
        --this.subtxs_;
    }

    protected abstract Object getState();

    protected List getSubtxawares() {
        return this.subtxawares_;
    }

    protected CompositeTransactionImp getCT() {
        return this.ct_;
    }

    protected int getSubTransactionCount() {
        return this.subtxs_;
    }

    protected Stack getSynchronizations() {
        return this.synchronizations_;
    }

    protected void addSynchronizations(Stack stack) {
        while (!stack.empty()) {
            Synchronization synchronization = (Synchronization)stack.pop();
            this.synchronizations_.push(synchronization);
        }
    }
}

