/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.icatch.imp.PropagationMessage;
import java.io.IOException;
import java.util.Stack;

class Propagator
implements Runnable {
    protected static long retryInterval = 10000L;
    protected int threadcount_ = 1;
    protected Stack buffer_ = new Stack();
    protected boolean needed_ = true;
    protected Propagator retrier_ = null;
    protected Console output_ = null;

    protected Propagator(Console console) {
        this.threadcount_ = 1;
        this.needed_ = true;
        this.output_ = console;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public Propagator(int n, Console console) {
        this.threadcount_ = n;
        this.output_ = console;
        this.needed_ = true;
        this.retrier_ = new Propagator(console);
        for (int i = 0; i < n; ++i) {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public synchronized void addPropagationMessage(PropagationMessage propagationMessage) {
        this.buffer_.push(propagationMessage);
        this.notify();
    }

    public synchronized void stopThreads() {
        this.needed_ = false;
        if (this.retrier_ != null) {
            this.retrier_.stopThreads();
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.needed_) {
            PropagationMessage propagationMessage = null;
            try {
                Propagator propagator = this;
                synchronized (propagator) {
                    while (this.buffer_.empty() && this.needed_) {
                        this.wait();
                    }
                    if (!this.needed_) {
                        break;
                    }
                    propagationMessage = (PropagationMessage)this.buffer_.pop();
                    if (this.retrier_ == null) {
                        Thread.currentThread();
                        Thread.sleep(retryInterval);
                        if (this.output_ != null && propagationMessage != null) {
                            try {
                                this.output_.println("Propagator: retrying message: " + propagationMessage);
                            }
                            catch (IOException iOException) {
                                System.out.println("WARNING: propagator thread console failure");
                            }
                        }
                    }
                }
                boolean bl = propagationMessage.submit();
                if (!bl) continue;
                if (this.retrier_ == null) {
                    this.addPropagationMessage(propagationMessage);
                    continue;
                }
                this.retrier_.addPropagationMessage(propagationMessage);
            }
            catch (Exception exception) {
                if (this.output_ == null) continue;
                try {
                    this.output_.println("ERROR in propagator thread: " + exception.getMessage() + " " + exception.getClass().getName());
                    if (propagationMessage == null) continue;
                    this.output_.println("while sending message: " + propagationMessage);
                }
                catch (IOException iOException) {
                    System.out.println("WARNING: propagator thread output failure :" + iOException.getMessage());
                }
            }
        }
    }
}

