/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTerminator;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import java.util.Hashtable;
import java.util.Stack;

class CompositeTerminatorImp
implements CompositeTerminator {
    protected CoordinatorImp coordinator_ = null;
    protected CompositeTransactionImp transaction_ = null;
    protected TransactionService ts_ = null;

    CompositeTerminatorImp(TransactionService transactionService, CompositeTransactionImp compositeTransactionImp, CoordinatorImp coordinatorImp) {
        this.ts_ = transactionService;
        this.coordinator_ = coordinatorImp;
        this.transaction_ = compositeTransactionImp;
    }

    public void commit() throws HeurRollbackException, HeurMixedException, HeurHazardException, SysException, SecurityException, RollbackException {
        Stack<Exception> stack = new Stack<Exception>();
        TransactionControl transactionControl = this.transaction_.getTransactionControl();
        this.transaction_.doCommit();
        Hashtable hashtable = transactionControl.getExtent().getRemoteParticipants();
        this.coordinator_.setGlobalSiblingCount(this.coordinator_.getLocalSiblingCount());
        this.coordinator_.setCascadeList(hashtable);
        if (this.transaction_.isRoot()) {
            try {
                this.coordinator_.terminate(true);
            }
            catch (RollbackException rollbackException) {
                throw rollbackException;
            }
            catch (HeurHazardException heurHazardException) {
                throw heurHazardException;
            }
            catch (HeurRollbackException heurRollbackException) {
                throw heurRollbackException;
            }
            catch (HeurMixedException heurMixedException) {
                throw heurMixedException;
            }
            catch (SysException sysException) {
                throw sysException;
            }
            catch (Exception exception) {
                stack.push(exception);
                throw new SysException("Unexpected error: " + exception.getMessage(), stack);
            }
        }
    }

    public void rollback() throws IllegalStateException, SysException {
        Stack<Exception> stack = new Stack<Exception>();
        this.transaction_.doRollback();
        if (this.transaction_.isRoot()) {
            try {
                this.coordinator_.terminate(false);
            }
            catch (Exception exception) {
                stack.push(exception);
                throw new SysException("Unexpected error in rollback: " + exception.getMessage(), stack);
            }
        }
    }
}

