/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import java.io.Serializable;
import java.util.Properties;
import java.util.Stack;

public abstract class AbstractCompositeTransaction
implements CompositeTransaction,
Serializable {
    protected Stack lineage_;
    protected String tid_;
    protected boolean serial_;
    protected HeuristicMessage tag_;
    protected Properties properties_;

    private static void fail() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This functionality is not available for this instance");
    }

    public AbstractCompositeTransaction() {
    }

    public AbstractCompositeTransaction(String string, Stack stack, boolean bl) {
        this.tid_ = string;
        this.lineage_ = stack;
        if (this.lineage_ == null) {
            this.lineage_ = new Stack();
            this.properties_ = new Properties();
        } else if (!this.lineage_.empty()) {
            CompositeTransaction compositeTransaction = (CompositeTransaction)this.lineage_.peek();
            this.properties_ = compositeTransaction.getProperties();
        }
        if (this.properties_ == null) {
            this.properties_ = new Properties();
        }
        this.serial_ = bl;
    }

    public String getTid() {
        return this.tid_;
    }

    public void setTag(HeuristicMessage heuristicMessage) {
        this.tag_ = heuristicMessage;
    }

    public boolean isSerial() {
        return this.serial_;
    }

    public boolean isLocal() {
        return false;
    }

    public TransactionControl getTransactionControl() throws UnsupportedOperationException {
        return null;
    }

    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        throw new UnsupportedOperationException("addParticipant");
    }

    public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, UnsupportedOperationException, SysException {
        throw new UnsupportedOperationException("registerSynchronization");
    }

    public Stack getLineage() {
        return (Stack)this.lineage_.clone();
    }

    public boolean isRoot() {
        return this.lineage_ == null || this.lineage_.size() == 0;
    }

    public boolean isAncestorOf(CompositeTransaction compositeTransaction) {
        return compositeTransaction.isDescendantOf((CompositeTransaction)this);
    }

    public boolean isDescendantOf(CompositeTransaction compositeTransaction) {
        CompositeTransaction compositeTransaction2 = null;
        if (this.lineage_ != null && !this.lineage_.empty()) {
            compositeTransaction2 = (CompositeTransaction)this.lineage_.peek();
        }
        return this.isSameTransaction(compositeTransaction) || compositeTransaction2 != null && compositeTransaction2.isDescendantOf(compositeTransaction);
    }

    public boolean isRelatedTransaction(CompositeTransaction compositeTransaction) {
        Stack stack = null;
        stack = this.lineage_ == null ? new Stack() : (Stack)this.lineage_.clone();
        if (stack.empty()) {
            return this.isAncestorOf(compositeTransaction);
        }
        CompositeTransaction compositeTransaction2 = null;
        while (!stack.empty()) {
            compositeTransaction2 = (CompositeTransaction)stack.pop();
        }
        return compositeTransaction2.isAncestorOf(compositeTransaction);
    }

    public boolean isSameTransaction(CompositeTransaction compositeTransaction) {
        return this.equals(compositeTransaction);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompositeTransaction)) {
            return false;
        }
        CompositeTransaction compositeTransaction = (CompositeTransaction)object;
        return compositeTransaction.getTid().intern().equals(this.getTid().intern());
    }

    public CompositeCoordinator getCompositeCoordinator() throws SysException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented: class for testing ");
    }

    public void addSubTxAwareParticipant(SubTxAwareParticipant subTxAwareParticipant) throws SysException, UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("addSubTxAwareParticipant");
    }

    public CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        AbstractCompositeTransaction.fail();
        return null;
    }

    public void setSerial() throws IllegalStateException, SysException {
        AbstractCompositeTransaction.fail();
    }

    public int getLocalSubTxCount() {
        return 0;
    }

    public Extent getExtent() {
        AbstractCompositeTransaction.fail();
        return null;
    }

    public long getTimeout() {
        AbstractCompositeTransaction.fail();
        return 0L;
    }

    public void setRollbackOnly() {
        AbstractCompositeTransaction.fail();
    }

    public void commit() throws HeurRollbackException, HeurMixedException, HeurHazardException, SysException, SecurityException, RollbackException {
        AbstractCompositeTransaction.fail();
    }

    public void rollback() throws IllegalStateException, SysException {
        AbstractCompositeTransaction.fail();
    }

    public void setProperty(String string, String string2) {
        if (this.getProperty(string) == null) {
            this.properties_.setProperty(string, string2);
        }
    }

    public String getProperty(String string) {
        return this.properties_.getProperty(string);
    }

    public Properties getProperties() {
        return (Properties)this.properties_.clone();
    }

    public Object getState() {
        throw new UnsupportedOperationException("getState");
    }
}

