/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.imp;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.imp.LocalLogAdministratorTableModel;
import com.atomikos.icatch.admin.imp.MessageTableModel;
import com.atomikos.icatch.admin.imp.StateDescriptor;
import com.atomikos.icatch.admin.imp.StateTableModel;
import com.atomikos.persistence.LogException;
import com.atomikos.swing.ExtensionsFileFilter;
import com.atomikos.swing.PropertiesPanel;
import com.atomikos.swing.PropertiesTableModel;
import com.atomikos.swing.PropertyListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

class AdminTool
implements PropertyListener,
ListSelectionListener {
    private LogControl control_;
    private JFrame frame_;
    private LocalLogAdministratorTableModel model_;
    private Vector data_;
    private Timer timer_;
    private JFileChooser fc_;
    private PropertyListener pListener_;
    private ResourceBundle messages_ = ResourceBundle.getBundle("com.atomikos.icatch.admin.AdminToolResourceBundle");

    static boolean hasDetails(int n) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 6: {
                bl = false;
                break;
            }
            case 5: {
                bl = false;
                break;
            }
            case 7: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    static Object convertState(int n) {
        TxState txState = null;
        switch (n) {
            case 0: {
                txState = TxState.IN_DOUBT;
                break;
            }
            case 4: {
                txState = TxState.HEUR_MIXED;
                break;
            }
            case 3: {
                txState = TxState.HEUR_HAZARD;
                break;
            }
            case 1: {
                txState = TxState.HEUR_COMMITTED;
                break;
            }
            case 2: {
                txState = TxState.HEUR_ABORTED;
                break;
            }
            case 6: {
                txState = TxState.COMMITTING;
                break;
            }
            case 5: {
                txState = TxState.ABORTING;
                break;
            }
            case 7: {
                txState = TxState.TERMINATED;
                break;
            }
        }
        return txState;
    }

    private static StateDescriptor getStateDescriptor(AdminTransaction adminTransaction, int n) {
        Object object = AdminTool.convertState(n);
        HeuristicMessage[] heuristicMessageArray = adminTransaction.getHeuristicMessages(n);
        return new StateDescriptor(object, heuristicMessageArray);
    }

    private static Vector getStateDescriptors(Object object) {
        AdminTransaction adminTransaction = (AdminTransaction)object;
        Vector<StateDescriptor> vector = new Vector<StateDescriptor>();
        StateDescriptor stateDescriptor = null;
        stateDescriptor = AdminTool.getStateDescriptor(adminTransaction, 4);
        if (stateDescriptor.messages != null && stateDescriptor.messages.length != 0) {
            vector.addElement(stateDescriptor);
        }
        stateDescriptor = AdminTool.getStateDescriptor(adminTransaction, 3);
        if (stateDescriptor.messages != null && stateDescriptor.messages.length != 0) {
            vector.addElement(stateDescriptor);
        }
        stateDescriptor = AdminTool.getStateDescriptor(adminTransaction, 1);
        if (stateDescriptor.messages != null && stateDescriptor.messages.length != 0) {
            vector.addElement(stateDescriptor);
        }
        stateDescriptor = AdminTool.getStateDescriptor(adminTransaction, 2);
        if (stateDescriptor.messages != null && stateDescriptor.messages.length != 0) {
            vector.addElement(stateDescriptor);
        }
        stateDescriptor = AdminTool.getStateDescriptor(adminTransaction, 7);
        if (stateDescriptor.messages != null && stateDescriptor.messages.length != 0) {
            vector.addElement(stateDescriptor);
        }
        return vector;
    }

    private static JPanel getMessagePanel(HeuristicMessage[] heuristicMessageArray) {
        MessageTableModel messageTableModel = new MessageTableModel(heuristicMessageArray);
        JTable jTable = new JTable(messageTableModel);
        jTable.setPreferredScrollableViewportSize(new Dimension(300, 70));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    AdminTool(LogControl logControl) {
        this.frame_ = new JFrame(this.messages_.getString("adminToolTitle"));
        this.control_ = logControl;
        this.timer_ = new Timer(7000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminTool.this.model_.refresh();
            }
        });
        this.timer_.start();
        this.init();
    }

    private void init() {
        JTable jTable = null;
        try {
            jTable = this.getJTable();
        }
        catch (LogException logException) {
            throw new RuntimeException(logException.getMessage());
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        File file = new File("archive.txt");
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fc_ = new JFileChooser(file);
        String[] stringArray = new String[]{"txt"};
        this.fc_.setFileFilter((FileFilter)new ExtensionsFileFilter(stringArray));
        this.fc_.setDialogTitle(this.messages_.getString("appendDialogTitle"));
        this.fc_.setFileSelectionMode(0);
        this.frame_.getContentPane().add((Component)jScrollPane, "Center");
        this.frame_.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (AdminTool.this.timer_ != null) {
                    AdminTool.this.timer_.stop();
                }
            }
        });
        this.frame_.pack();
        this.frame_.setVisible(true);
        this.pListener_ = this;
    }

    private void forget(Object object, int n) {
        AdminTransaction adminTransaction = (AdminTransaction)object;
        adminTransaction.forceForget();
        this.model_.rowDeleted(n);
    }

    private void commit(Object object, int n) {
        try {
            AdminTransaction adminTransaction = (AdminTransaction)object;
            adminTransaction.forceCommit();
            this.model_.refresh();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void rollback(Object object, int n) {
        try {
            AdminTransaction adminTransaction = (AdminTransaction)object;
            adminTransaction.forceRollback();
            this.model_.refresh();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getHeuristicDetails(AdminTransaction adminTransaction, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        HeuristicMessage[] heuristicMessageArray = adminTransaction.getHeuristicMessages(n);
        for (int i = 0; i < heuristicMessageArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append(AdminTool.convertState(n) + ": ");
            }
            stringBuffer.append(heuristicMessageArray[i]);
            if (i >= heuristicMessageArray.length - 1) continue;
            stringBuffer.append(" -- ");
        }
        return stringBuffer.toString();
    }

    private String getMessages(Object object) {
        HeuristicMessage[] heuristicMessageArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        AdminTransaction adminTransaction = (AdminTransaction)object;
        Object object2 = AdminTool.convertState(adminTransaction.getState());
        heuristicMessageArray = adminTransaction.getHeuristicMessages();
        if (adminTransaction.wasCommitted()) {
            stringBuffer.append(this.messages_.getString("commitAttemptedMessage"));
        } else if (adminTransaction.getState() != 0) {
            stringBuffer.append(this.messages_.getString("rollbackAttemptedMessage"));
        }
        for (int i = 0; i < heuristicMessageArray.length; ++i) {
            stringBuffer.append(heuristicMessageArray[i]);
            if (i >= heuristicMessageArray.length - 1) continue;
            stringBuffer.append(" -- ");
        }
        if (adminTransaction.getState() == 4 || adminTransaction.getState() == 3) {
            stringBuffer.append(this.messages_.getString("ofWhichMessage"));
            stringBuffer.append(this.getHeuristicDetails(adminTransaction, 1));
            stringBuffer.append(this.getHeuristicDetails(adminTransaction, 2));
            stringBuffer.append(this.getHeuristicDetails(adminTransaction, 4));
            stringBuffer.append(this.getHeuristicDetails(adminTransaction, 3));
        }
        return stringBuffer.toString();
    }

    private JTable getJTable() throws LogException {
        JTable jTable = null;
        Vector<AdminTransaction> vector = new Vector<AdminTransaction>();
        AdminTransaction[] adminTransactionArray = this.control_.getAdminTransactions();
        if (adminTransactionArray != null && adminTransactionArray.length > 0) {
            for (int i = 0; i < adminTransactionArray.length; ++i) {
                vector.addElement(adminTransactionArray[i]);
            }
        }
        this.data_ = vector;
        LocalLogAdministratorTableModel localLogAdministratorTableModel = new LocalLogAdministratorTableModel(vector);
        jTable = new JTable(localLogAdministratorTableModel);
        jTable.setSelectionMode(0);
        this.model_ = localLogAdministratorTableModel;
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        return jTable;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.processEvent(listSelectionEvent);
    }

    void processEvent(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            AdminTransaction adminTransaction = (AdminTransaction)this.data_.elementAt(n);
            String string = null;
            Object object = null;
            string = adminTransaction.getTid();
            object = AdminTool.convertState(adminTransaction.getState());
            if (!object.equals(TxState.IN_DOUBT)) {
                if (AdminTool.hasDetails(adminTransaction.getState())) {
                    Object[] objectArray = new Object[]{this.messages_.getString("forgetNoArchiveOption"), this.messages_.getString("forgetAndArchiveOption"), this.messages_.getString("keepInLogOption")};
                    Vector vector = AdminTool.getStateDescriptors(adminTransaction);
                    StateTableModel stateTableModel = new StateTableModel(vector);
                    PropertiesPanel propertiesPanel = new PropertiesPanel((PropertiesTableModel)stateTableModel, true);
                    String string2 = null;
                    string2 = adminTransaction.wasCommitted() ? this.messages_.getString("commitOutcomeMessage") : this.messages_.getString("rollbackOutcomeMessage");
                    propertiesPanel.addPropertyListener(this.pListener_);
                    int n2 = JOptionPane.showOptionDialog(this.frame_, propertiesPanel.getPanel(), string2 + string.toString(), 1, 3, null, objectArray, objectArray[2]);
                    if (n2 == 0 || n2 == 1) {
                        if (n2 == 1) {
                            this.fc_.setDialogTitle(this.messages_.getString("appendDialogTitle"));
                            int n3 = this.fc_.showOpenDialog(this.frame_);
                            if (n3 == 0) {
                                try {
                                    File file = this.fc_.getSelectedFile();
                                    FileWriter fileWriter = new FileWriter(file.getPath(), true);
                                    fileWriter.write(this.messages_.getString("rootTransactionMessage") + string.toString() + " ");
                                    fileWriter.write(this.getMessages(this.data_.elementAt(n)));
                                    fileWriter.write("\r");
                                    fileWriter.flush();
                                    fileWriter.close();
                                    this.forget(this.data_.elementAt(n), n);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        } else {
                            this.forget(this.data_.elementAt(n), n);
                        }
                    } else {
                        listSelectionModel.removeSelectionInterval(n, n);
                    }
                }
            } else {
                Object[] objectArray = new Object[]{this.messages_.getString("commitOption"), this.messages_.getString("rollbackOption"), this.messages_.getString("keepInLogOption")};
                AdminTransaction adminTransaction2 = (AdminTransaction)this.data_.elementAt(n);
                JPanel jPanel = AdminTool.getMessagePanel(adminTransaction2.getHeuristicMessages());
                int n4 = JOptionPane.showOptionDialog(this.frame_, jPanel, this.messages_.getString("selectedTransactionMessage") + string.toString(), 1, 3, null, objectArray, objectArray[2]);
                if (n4 == 0) {
                    this.commit(this.data_.elementAt(n), n);
                } else if (n4 == 1) {
                    this.rollback(this.data_.elementAt(n), n);
                }
                listSelectionModel.removeSelectionInterval(n, n);
            }
            listSelectionModel.clearSelection();
        }
    }

    public void newProperty(PropertiesTableModel propertiesTableModel) {
        throw new RuntimeException("Should not be called");
    }

    public void deleteProperty(PropertiesTableModel propertiesTableModel, int n) {
        throw new RuntimeException("Should not be called");
    }

    public void editProperty(PropertiesTableModel propertiesTableModel, int n) {
        Vector vector = ((StateTableModel)propertiesTableModel).getData();
        StateDescriptor stateDescriptor = (StateDescriptor)vector.elementAt(n);
        JPanel jPanel = AdminTool.getMessagePanel(stateDescriptor.messages);
        int n2 = JOptionPane.showConfirmDialog(this.frame_, jPanel, this.messages_.getString("stateDetailsTitle"), -1);
    }
}

