/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.transaction.SystemException;

public abstract class MessageProducerSession {
    private AbstractConnectionFactoryBean connectionFactoryBean;
    private String user;
    private String password;
    private Destination destination;
    private Destination replyToDestination;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    private transient Connection connection;
    private transient Session session;
    private transient MessageProducer sender;

    protected MessageProducerSession() {
        this.setTimeToLive(0L);
        this.setDeliveryMode(2);
        this.setPriority(4);
    }

    private synchronized MessageProducer refresh() throws JMSException {
        MessageProducer messageProducer = null;
        if (this.destination == null) {
            throw new JMSException("Please call setDestination first!");
        }
        this.connection = this.user != null ? this.connectionFactoryBean.createConnection(this.user, this.password) : this.connectionFactoryBean.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(true, 0);
        this.sender = messageProducer = this.session.createProducer(this.destination);
        return messageProducer;
    }

    private synchronized void closeResources() {
        if (this.session != null) {
            try {
                this.session.close();
                this.session = null;
            }
            catch (JMSException jMSException) {
                Configuration.logInfo((String)"Error closing JMS session", (Exception)((Object)jMSException));
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (JMSException jMSException) {
                Configuration.logInfo((String)"Error closing JMS connection", (Exception)((Object)jMSException));
            }
        }
        this.sender = null;
    }

    protected void setAbstractConnectionFactoryBean(AbstractConnectionFactoryBean abstractConnectionFactoryBean) {
        this.connectionFactoryBean = abstractConnectionFactoryBean;
    }

    protected AbstractConnectionFactoryBean getAbstractConnectionFactoryBean() {
        return this.connectionFactoryBean;
    }

    protected Destination getDestination() {
        return this.destination;
    }

    protected void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getUser() {
        return this.user;
    }

    public void setReplyToDestination(Destination destination) {
        this.replyToDestination = destination;
    }

    public Destination getReplyToDestination() {
        return this.replyToDestination;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void sendMessage(Message message) throws JMSException {
        UserTransactionManager userTransactionManager = new UserTransactionManager();
        try {
            if (userTransactionManager.getStatus() != 0) {
                throw new JMSException("This method requires an active transaction!");
            }
        }
        catch (SystemException systemException) {
            Configuration.logWarning((String)"Error in getting transaction status", (Exception)((Object)systemException));
            throw new RuntimeException(systemException.getMessage());
        }
        try {
            if (this.sender == null) {
                this.sender = this.refresh();
            }
            if (this.replyToDestination != null) {
                message.setJMSReplyTo(this.replyToDestination);
            }
            Configuration.logInfo((String)("Calling send ( " + message + " ,  " + this.deliveryMode + " , " + this.priority + " , " + this.timeToLive + " )..."));
            this.sender.send(message, this.deliveryMode, this.priority, this.timeToLive);
            Configuration.logDebug((String)"Send done!");
        }
        catch (JMSException jMSException) {
            this.closeResources();
            this.sender = null;
            Configuration.logInfo((String)"Error in sending JMS message", (Exception)((Object)jMSException));
            throw jMSException;
        }
    }

    public TextMessage createTextMessage() throws JMSException {
        TextMessage textMessage = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            textMessage = this.session.createTextMessage();
        }
        catch (JMSException jMSException) {
            Configuration.logInfo((String)"Error creating new message", (Exception)((Object)jMSException));
            this.closeResources();
            throw jMSException;
        }
        return textMessage;
    }

    public MapMessage createMapMessage() throws JMSException {
        MapMessage mapMessage = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            mapMessage = this.session.createMapMessage();
        }
        catch (JMSException jMSException) {
            Configuration.logInfo((String)"Error creating new message", (Exception)((Object)jMSException));
            this.closeResources();
            throw jMSException;
        }
        return mapMessage;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessage objectMessage = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            objectMessage = this.session.createObjectMessage();
        }
        catch (JMSException jMSException) {
            Configuration.logInfo((String)"Error creating new message", (Exception)((Object)jMSException));
            this.closeResources();
            throw jMSException;
        }
        return objectMessage;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        BytesMessage bytesMessage = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            bytesMessage = this.session.createBytesMessage();
        }
        catch (JMSException jMSException) {
            Configuration.logInfo((String)"Error creating new message", (Exception)((Object)jMSException));
            this.closeResources();
            throw jMSException;
        }
        return bytesMessage;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        StreamMessage streamMessage = null;
        try {
            if (this.session == null) {
                this.refresh();
            }
            streamMessage = this.session.createStreamMessage();
        }
        catch (JMSException jMSException) {
            Configuration.logInfo((String)"Error creating new message", (Exception)((Object)jMSException));
            this.closeResources();
            throw jMSException;
        }
        return streamMessage;
    }

    public void stop() {
        this.closeResources();
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setDeliveryMode(int n) {
        this.deliveryMode = n;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public void setTimeToLive(long l) {
        this.timeToLive = l;
    }
}

