/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import com.atomikos.jms.MessageConsumerSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;

public abstract class MessageConsumerSessionPool {
    private AbstractConnectionFactoryBean connectionFactoryBean;
    private MessageListener messageListener;
    private String user;
    private String password;
    private Destination destination;
    private int transactionTimeout;
    private int poolSize;
    private List sessions = new ArrayList();
    private boolean daemonThreads;
    private boolean notifyListenerOnClose = false;
    private String messageSelector;
    private ExceptionListener exceptionListener;

    protected MessageConsumerSessionPool() {
        this.setPoolSize(1);
    }

    protected void setAbstractConnectionFactoryBean(AbstractConnectionFactoryBean abstractConnectionFactoryBean) {
        this.connectionFactoryBean = abstractConnectionFactoryBean;
    }

    protected AbstractConnectionFactoryBean getAbstractConnectionFactoryBean() {
        return this.connectionFactoryBean;
    }

    protected Destination getDestination() {
        return this.destination;
    }

    protected void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setDaemonThreads(boolean bl) {
        this.daemonThreads = bl;
    }

    public boolean getDaemonThreads() {
        return this.daemonThreads;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
        Iterator iterator = this.sessions.iterator();
        while (iterator.hasNext()) {
            MessageConsumerSession messageConsumerSession = (MessageConsumerSession)iterator.next();
            messageConsumerSession.setMessageListener(messageListener);
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setTransactionTimeout(int n) {
        this.transactionTimeout = n;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String string) {
        this.messageSelector = string;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int n) {
        this.poolSize = n;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected abstract MessageConsumerSession createSession();

    public void start() throws JMSException {
        if (this.destination == null) {
            throw new JMSException("MessageConsumerSessionPool: destination not specified");
        }
        if (this.connectionFactoryBean == null) {
            throw new JMSException("MessageConsumerSessionPool: factory not set");
        }
        if (this.messageListener == null) {
            throw new JMSException("MessageConsumerSessionPool: messageListener not set");
        }
        for (int i = 0; i < this.poolSize; ++i) {
            MessageConsumerSession messageConsumerSession = this.createSession();
            messageConsumerSession.setMessageListener(this.messageListener);
            messageConsumerSession.setPassword(this.password);
            messageConsumerSession.setUser(this.user);
            messageConsumerSession.setDestination(this.destination);
            messageConsumerSession.setAbstractConnectionFactoryBean(this.connectionFactoryBean);
            messageConsumerSession.setTransactionTimeout(this.transactionTimeout);
            messageConsumerSession.setDaemonThreads(this.daemonThreads);
            messageConsumerSession.setNotifyListenerOnClose(this.notifyListenerOnClose);
            messageConsumerSession.setMessageSelector(this.getMessageSelector());
            messageConsumerSession.setExceptionListener(this.exceptionListener);
            try {
                messageConsumerSession.startListening();
            }
            catch (Exception exception) {
                Configuration.logWarning((String)"Error starting pool", (Exception)exception);
            }
            this.sessions.add(messageConsumerSession);
        }
        this.setMessageListener(this.messageListener);
    }

    public void stop() {
        Iterator iterator = this.sessions.iterator();
        while (iterator.hasNext()) {
            MessageConsumerSession messageConsumerSession = (MessageConsumerSession)iterator.next();
            messageConsumerSession.stopListening();
        }
    }

    public boolean getNotifyListenerOnClose() {
        return this.notifyListenerOnClose;
    }

    public void setNotifyListenerOnClose(boolean bl) {
        this.notifyListenerOnClose = bl;
        Iterator iterator = this.sessions.iterator();
        while (iterator.hasNext()) {
            MessageConsumerSession messageConsumerSession = (MessageConsumerSession)iterator.next();
            messageConsumerSession.setNotifyListenerOnClose(bl);
        }
    }
}

