/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.jms.DefaultJtaMessageProducer;
import com.atomikos.jms.HeuristicQueueSender;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.transaction.xa.XAResource;

class JtaQueueSender
extends DefaultJtaMessageProducer
implements HeuristicQueueSender {
    JtaQueueSender(QueueSender queueSender, TransactionalResource transactionalResource, XAResource xAResource) {
        super((MessageProducer)queueSender, transactionalResource, xAResource);
    }

    private QueueSender getQueueSender() {
        return (QueueSender)this.getMessageProducer();
    }

    public void send(Message message, HeuristicMessage heuristicMessage) throws JMSException {
        this.sendToDefaultDestination(message, heuristicMessage);
    }

    public void send(Message message, int n, int n2, long l, HeuristicMessage heuristicMessage) throws JMSException {
        this.sendToDefaultDestination(message, n, n2, l, heuristicMessage);
    }

    public void send(Queue queue, Message message, HeuristicMessage heuristicMessage) throws JMSException {
        this.sendToDestination((Destination)queue, message, heuristicMessage);
    }

    public void send(Queue queue, Message message, int n, int n2, long l, HeuristicMessage heuristicMessage) throws JMSException {
        this.sendToDestination((Destination)queue, message, n, n2, l, heuristicMessage);
    }

    public void send(Queue queue, Message message) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage("Sending of JMS Message with ID: " + message.getJMSMessageID());
        this.sendToDestination((Destination)queue, message, (HeuristicMessage)stringHeuristicMessage);
    }

    public void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage("Sending of JMS Message with ID: " + message.getJMSMessageID());
        this.sendToDestination((Destination)queue, message, n, n2, l, (HeuristicMessage)stringHeuristicMessage);
    }

    public Queue getQueue() throws JMSException {
        return this.getQueueSender().getQueue();
    }

    public void send(Message message, String string) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string);
        this.send(message, (HeuristicMessage)stringHeuristicMessage);
    }

    public void send(Message message, int n, int n2, long l, String string) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string);
        this.send(message, n, n2, l, (HeuristicMessage)stringHeuristicMessage);
    }

    public void send(Queue queue, Message message, String string) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string);
        this.send(queue, message, (HeuristicMessage)stringHeuristicMessage);
    }

    public void send(Queue queue, Message message, int n, int n2, long l, String string) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string);
        this.send(queue, message, n, n2, l, (HeuristicMessage)stringHeuristicMessage);
    }
}

