/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.SysException;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.MessageProducerSession;
import com.atomikos.jms.MessageProducerSessionFactory;
import java.util.Enumeration;
import java.util.Stack;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public abstract class AbstractBridge
implements MessageListener {
    private MessageProducerSessionFactory destinationFactory;
    private ThreadLocal destinationMap = new ThreadLocal();

    protected AbstractBridge() {
    }

    private MessageProducerSession getDestination() {
        MessageProducerSession messageProducerSession = null;
        messageProducerSession = (MessageProducerSession)this.destinationMap.get();
        if (messageProducerSession == null) {
            messageProducerSession = this.destinationFactory.createMessageProducerSession();
            this.destinationMap.set(messageProducerSession);
        }
        return messageProducerSession;
    }

    public void setDestinationSessionFactory(MessageProducerSessionFactory messageProducerSessionFactory) {
        this.destinationFactory = messageProducerSessionFactory;
    }

    protected TextMessage createTextMessage() throws JMSException {
        TextMessage textMessage = null;
        textMessage = this.getDestination().createTextMessage();
        return textMessage;
    }

    protected BytesMessage createBytesMessage() throws JMSException {
        BytesMessage bytesMessage = null;
        bytesMessage = this.getDestination().createBytesMessage();
        return bytesMessage;
    }

    protected StreamMessage createStreamMessage() throws JMSException {
        StreamMessage streamMessage = null;
        streamMessage = this.getDestination().createStreamMessage();
        return streamMessage;
    }

    protected ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessage objectMessage = null;
        objectMessage = this.getDestination().createObjectMessage();
        return objectMessage;
    }

    protected MapMessage createMapMessage() throws JMSException {
        MapMessage mapMessage = null;
        mapMessage = this.getDestination().createMapMessage();
        return mapMessage;
    }

    protected void copyHeadersAndProperties(Message message, Message message2) throws JMSException {
        String string;
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Object object = message.getObjectProperty(string);
            message2.setObjectProperty(string, object);
        }
        string = message.getJMSCorrelationID();
        message2.setJMSCorrelationID(string);
        this.getDestination().setPriority(message.getJMSPriority());
        long l = message.getJMSExpiration();
        if (l > 0L) {
            long l2 = System.currentTimeMillis();
            long l3 = l - l2;
            if (l3 < 0L) {
                throw new JMSException("Message has expired");
            }
            this.getDestination().setTimeToLive(l3);
        } else {
            this.getDestination().setTimeToLive(0L);
        }
        String string2 = message.getJMSType();
        message2.setJMSType(string2);
        this.getDestination().setDeliveryMode(message.getJMSDeliveryMode());
    }

    protected abstract Message bridgeMessage(Message var1) throws JMSException;

    public final void onMessage(Message message) {
        try {
            if (message == null) {
                Configuration.logInfo((String)"Stopping JMS Bridge");
                this.getDestination().stop();
            } else {
                Message message2 = this.bridgeMessage(message);
                if (message2 != null) {
                    this.getDestination().sendMessage(message2);
                }
            }
        }
        catch (JMSException jMSException) {
            Configuration.logInfo((String)"Error during message processing", (Exception)((Object)jMSException));
            Stack<JMSException> stack = new Stack<JMSException>();
            stack.push(jMSException);
            throw new SysException("Error during message processing", stack);
        }
    }
}

