/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.nonxa.NonXAParticipant;
import com.atomikos.jdbc.nonxa.NonXAPooledConnectionImp;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.PooledConnection;

class ThreadLocalConnection
implements InvocationHandler {
    private int useCount = 0;
    private Connection wrapped;
    private NonXAPooledConnectionImp pooledConnection;
    private CompositeTransaction transaction;
    private boolean stale;
    private NonXAParticipant participant;

    static Object newInstance(NonXAPooledConnectionImp nonXAPooledConnectionImp) throws SQLException {
        Connection connection = nonXAPooledConnectionImp.getConnection();
        ArrayList arrayList = ThreadLocalConnection.getAllImplementedInterfaces(connection.getClass());
        Class[] classArray = arrayList.toArray(new Class[0]);
        return Proxy.newProxyInstance(connection.getClass().getClassLoader(), classArray, (InvocationHandler)new ThreadLocalConnection(nonXAPooledConnectionImp));
    }

    static ArrayList getAllImplementedInterfaces(Class clazz) {
        ArrayList arrayList = null;
        arrayList = clazz.getSuperclass() != null ? ThreadLocalConnection.getAllImplementedInterfaces(clazz.getSuperclass()) : new ArrayList();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            arrayList.add(classArray[i]);
        }
        return arrayList;
    }

    private ThreadLocalConnection(NonXAPooledConnectionImp nonXAPooledConnectionImp) throws SQLException {
        this.wrapped = nonXAPooledConnectionImp.getConnection();
        this.pooledConnection = nonXAPooledConnectionImp;
        this.setStale(false);
        this.resetForTransaction();
        this.updateInTransaction();
    }

    private void resetForTransaction() {
        this.setTransaction(null);
        this.participant = null;
    }

    private void setStale(boolean bl) {
        this.stale = bl;
    }

    boolean isStale() {
        return this.stale;
    }

    private void setTransaction(CompositeTransaction compositeTransaction) {
        this.transaction = compositeTransaction;
    }

    private void updateInTransaction() throws SQLException {
        CompositeTransactionManager compositeTransactionManager = Configuration.getCompositeTransactionManager();
        if (compositeTransactionManager == null) {
            return;
        }
        CompositeTransaction compositeTransaction = compositeTransactionManager.getCompositeTransaction();
        if (compositeTransaction != null && compositeTransaction.getProperty("com.atomikos.icatch.jta.transaction") != null) {
            if (this.isInTransaction() && !this.isInTransaction(compositeTransaction)) {
                throw new SQLException("Connection accessed by transaction " + compositeTransaction.getTid() + " is already in use in another transaction: " + this.transaction.getTid() + " Non-XA connections are not compatible with nested transaction use.");
            }
            this.setTransaction(compositeTransaction);
            if (this.participant == null) {
                this.participant = new NonXAParticipant(this);
                compositeTransaction.addParticipant((Participant)this.participant);
                this.wrapped.setAutoCommit(false);
            }
        } else if (this.isInTransaction()) {
            this.transactionTerminated(false);
        }
    }

    private boolean isInTransaction() {
        return this.transaction != null;
    }

    private boolean isInTransaction(CompositeTransaction compositeTransaction) {
        boolean bl = false;
        if (this.isInTransaction()) {
            bl = this.transaction.isSameTransaction(compositeTransaction);
        }
        return bl;
    }

    private void decUseCount() {
        --this.useCount;
        this.checkReusability();
    }

    private void checkReusability() {
        if (this.useCount == 0 && !this.isInTransaction()) {
            Configuration.logDebug((String)"ThreadLocalConnection: detected reusability");
            this.setStale(true);
            this.pooledConnection.notifyCloseListeners();
        } else {
            Configuration.logDebug((String)"ThreadLocalConnection: not reusable yet");
        }
    }

    void addHeuristicMessage(HeuristicMessage heuristicMessage) {
        if (this.participant != null) {
            this.participant.addHeuristicMessage(heuristicMessage);
        }
    }

    void incUseCount() {
        ++this.useCount;
    }

    void transactionTerminated(boolean bl) throws SQLException {
        try {
            if (bl) {
                Configuration.logInfo((String)"ThreadLocalConnection: committing on connection...");
                this.wrapped.commit();
            } else {
                Configuration.logInfo((String)"ThreadLocalConnection: rolling back on connection...");
                this.wrapped.rollback();
            }
        }
        catch (SQLException sQLException) {
            this.pooledConnection.setInvalidated();
            throw sQLException;
        }
        finally {
            this.resetForTransaction();
            this.checkReusability();
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        if (this.isStale()) {
            throw new SQLException("Attempt to use connection after it was closed.");
        }
        this.updateInTransaction();
        if (method.getName().equals("close")) {
            this.decUseCount();
        } else {
            if (this.isInTransaction() && (method.getName().equals("rollback") || method.getName().equals("commit"))) {
                throw new SQLException("Rollback or Commit not allowed inside a managed transaction!");
            }
            try {
                Configuration.logDebug((String)("ThreadLocalConnection: delegating method " + method + " to wrapped connection with args: " + objectArray));
                object2 = method.invoke((Object)this.wrapped, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
            catch (Exception exception) {
                Configuration.logDebug((String)"ThreadLocalConnection: Unexpected invocation exception", (Exception)exception);
                throw new RuntimeException("Unexpected invocation exception: " + exception.getMessage());
            }
        }
        return object2;
    }

    public boolean usesConnection(PooledConnection pooledConnection) {
        return this.pooledConnection.equals(pooledConnection);
    }
}

