/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.jdbc.XPooledConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

class NonXAPooledConnectionImp
implements XPooledConnection {
    private Connection connection;
    private Date lastUsed;
    private boolean invalidated;
    private ArrayList listeners;

    NonXAPooledConnectionImp(Connection connection) {
        this.connection = connection;
        this.invalidated = false;
        this.listeners = new ArrayList();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void setStatementTimeout(int n) {
    }

    public int getStatementTimeout() {
        return 0;
    }

    public void setLastUse(Date date) {
        this.lastUsed = date;
    }

    public Date getLastUse() {
        return this.lastUsed;
    }

    public void setInvalidated() {
        this.invalidated = true;
    }

    public boolean getInvalidated() {
        return this.invalidated;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    void notifyCloseListeners() {
        List list = (List)this.listeners.clone();
        Iterator iterator = list.iterator();
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }
}

