/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.beans.BeanInspector;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.OraXidFactory;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.DataSourceShutdownHook;
import com.atomikos.jdbc.ExternalXAPooledConnectionImp;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.JtaDataSourceImp;
import com.atomikos.jdbc.XAConnectionFactory;
import com.atomikos.util.SerializableObjectFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SimpleDataSourceBean
implements HeuristicDataSource,
ConnectionPoolDataSource,
Serializable,
Referenceable {
    private transient JtaDataSourceImp ds_ = null;
    private transient XADataSource xads_ = null;
    private String resourceName_ = "someUniqueName";
    private String xidFactory_ = "Default";
    private int poolSize_ = 1;
    private int connectionTimeout_ = 30;
    private int statementTimeout_ = 30;
    private boolean exclusive_ = true;
    private String validatingQuery_ = "";
    private String xaProperties_ = "";
    private String xaDataSourceClassName_ = "";

    private Properties parseProperties() {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(this.xaProperties_, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf("=");
            if (n < 0) {
                throw new RuntimeException("Invalid xaProperties format");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            properties.setProperty(string2, string3);
        }
        return properties;
    }

    private synchronized void checkSetup(boolean bl) throws SQLException {
        Object object;
        Object object2;
        Serializable serializable;
        this.ds_ = JtaDataSourceImp.getInstance(this.getUniqueResourceName());
        if (this.ds_ != null && !bl) {
            return;
        }
        if (this.xads_ == null && this.getXaDataSourceClassName().equals("")) {
            throw new SQLException("SimpleDataSourceBean: xaDataSourceClassName not set.");
        }
        if (this.xidFactory_ == null) {
            throw new SQLException("SimpleDataSourceBean: xidFormat not set.");
        }
        try {
            serializable = Class.forName(this.getXaDataSourceClassName());
            this.xads_ = (XADataSource)serializable.newInstance();
            object2 = new BeanInspector((Object)this.xads_);
            object = this.parseProperties();
            Enumeration<?> enumeration = ((Properties)object).propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = ((Properties)object).getProperty(string);
                object2.setPropertyValue(string, string2);
            }
        }
        catch (Exception exception) {
            Configuration.logWarning((String)("SimpleDataSourceBean: could not configure XADataSource of class " + this.getXaDataSourceClassName()), (Exception)exception);
            throw new SQLException("Could not configure XADataSource: " + exception.getMessage() + " " + exception.getClass().getName());
        }
        serializable = null;
        serializable = this.getXaDataSourceClassName().toLowerCase().indexOf("oracle") < 0 ? new DefaultXidFactory() : new OraXidFactory();
        object2 = new XAConnectionFactory(this.resourceName_, "", "", this.xads_, (XidFactory)((Object)serializable));
        ((XAConnectionFactory)object2).setExclusive(this.exclusive_);
        this.ds_ = new JtaDataSourceImp((XAConnectionFactory)object2, this.poolSize_, this.connectionTimeout_, this.statementTimeout_, bl, !bl);
        object = new DataSourceShutdownHook(this.ds_);
        Runtime.getRuntime().addShutdownHook((Thread)object);
    }

    private synchronized void checkSetup() throws SQLException {
        this.checkSetup(false);
    }

    public void init() throws SQLException {
        this.checkSetup(false);
    }

    public void setUniqueResourceName(String string) {
        this.resourceName_ = string;
    }

    public String getUniqueResourceName() {
        return this.resourceName_;
    }

    public void setConnectionPoolSize(int n) {
        this.poolSize_ = n;
    }

    public int getConnectionPoolSize() {
        return this.poolSize_;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout_ = n;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout_;
    }

    public void setExclusiveConnectionMode(boolean bl) {
        this.exclusive_ = bl;
    }

    public boolean getExclusiveConnectionMode() {
        return this.exclusive_;
    }

    protected TransactionalResource getTransactionalResource() {
        try {
            this.checkSetup();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new RuntimeException(sQLException.getMessage());
        }
        return this.ds_.getTransactionalResource();
    }

    public void setValidatingQuery(String string) {
        this.validatingQuery_ = string;
    }

    public String getValidatingQuery() {
        return this.validatingQuery_;
    }

    public void setXaDataSourceClassName(String string) {
        this.xaDataSourceClassName_ = string;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName_;
    }

    public void setXaDataSourceProperties(String string) {
        this.xaProperties_ = string;
    }

    public String getXaDataSourceProperties() {
        return this.xaProperties_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws SQLException {
        this.checkSetup(true);
        String string = this.getValidatingQuery();
        if (string == null || string.equals("")) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.ds_.getConnection();
            try {
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                statement.close();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            Configuration.logWarning((String)("Error in validating query for resource " + this.getUniqueResourceName()), (Exception)sQLException);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string, string2);
    }

    public Connection getConnection(HeuristicMessage heuristicMessage) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(heuristicMessage);
    }

    public Connection getConnection(String string, String string2, HeuristicMessage heuristicMessage) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string, string2, heuristicMessage);
    }

    public Connection getConnection(String string) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string);
    }

    public Connection getConnection(String string, String string2, String string3) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string, string2, string3);
    }

    public int getLoginTimeout() throws SQLException {
        this.checkSetup();
        return this.ds_.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        this.checkSetup();
        return this.ds_.getLogWriter();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.checkSetup();
        this.ds_.setLoginTimeout(n);
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.checkSetup();
        this.ds_.setLogWriter(printWriter);
    }

    public void close() throws SQLException {
        if (this.ds_ != null) {
            this.ds_.close();
        }
    }

    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        this.checkSetup();
        ExternalXAPooledConnectionImp externalXAPooledConnectionImp = null;
        XAConnection xAConnection = this.xads_.getXAConnection();
        externalXAPooledConnectionImp = new ExternalXAPooledConnectionImp(xAConnection, this.getTransactionalResource(), this.getLogWriter());
        return externalXAPooledConnectionImp;
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        ExternalXAPooledConnectionImp externalXAPooledConnectionImp = null;
        this.checkSetup();
        XAConnection xAConnection = this.xads_.getXAConnection(string, string2);
        externalXAPooledConnectionImp = new ExternalXAPooledConnectionImp(xAConnection, this.getTransactionalResource(), this.getLogWriter());
        return externalXAPooledConnectionImp;
    }
}

