/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.LoggingXAResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.TxState;
import com.atomikos.jdbc.ConnectionProxy;
import com.atomikos.jdbc.DTPPooledConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class ExternalXAPooledConnectionImp
implements DTPPooledConnection,
ConnectionEventListener {
    protected Date lastUse_ = new Date();
    protected XAConnection myConn_;
    protected Vector listeners_ = new Vector();
    protected boolean invalidated_ = false;
    protected Date creationTime_ = new Date();
    protected boolean discarded_ = false;
    protected TransactionalResource resource_;
    protected XAResourceTransaction restx_;
    protected PrintWriter logWriter_;
    protected int statementTimeout_;
    protected HeuristicMessage msg_;
    protected Connection connectionProxy_;

    protected static void suspendResourceTransaction(ResourceTransaction resourceTransaction) {
        XAResourceTransaction xAResourceTransaction = (XAResourceTransaction)resourceTransaction;
        if (xAResourceTransaction != null && !xAResourceTransaction.getState().equals(TxState.TERMINATED)) {
            xAResourceTransaction.suspend();
        }
    }

    public String toString() {
        return new String("ExternalXAPooledConnectionImp" + this.creationTime_.getTime() + super.toString());
    }

    public ExternalXAPooledConnectionImp(XAConnection xAConnection, TransactionalResource transactionalResource) {
        this.myConn_ = xAConnection;
        this.myConn_.addConnectionEventListener(this);
        this.resource_ = transactionalResource;
    }

    protected ExternalXAPooledConnectionImp(XAConnection xAConnection, TransactionalResource transactionalResource, PrintWriter printWriter) {
        this(xAConnection, transactionalResource);
        this.logWriter_ = printWriter;
    }

    public void setConnection(XAConnection xAConnection) {
        if (this.myConn_ != null) {
            this.myConn_.removeConnectionEventListener(this);
        }
        this.myConn_ = xAConnection;
        this.myConn_.addConnectionEventListener(this);
    }

    public TransactionalResource getTransactionalResource() {
        return this.resource_;
    }

    public void setResourceTransaction(ResourceTransaction resourceTransaction) throws SQLException {
        if (!(resourceTransaction instanceof XAResourceTransaction)) {
            throw new RuntimeException("Expected: XAResourceTransaction");
        }
        this.restx_ = (XAResourceTransaction)resourceTransaction;
        XAResource xAResource = this.myConn_.getXAResource();
        if (this.logWriter_ != null) {
            xAResource = new LoggingXAResource(xAResource, this.logWriter_);
        }
        this.restx_.setXAResource(xAResource);
        if (this.msg_ != null) {
            this.restx_.addHeuristicMessage(this.msg_);
            this.msg_ = null;
        }
    }

    public ResourceTransaction unsetResourceTransaction() {
        XAResourceTransaction xAResourceTransaction = this.restx_;
        this.restx_ = null;
        return xAResourceTransaction;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null);
    }

    public void setInvalidated() {
        this.invalidated_ = true;
    }

    public boolean getInvalidated() {
        return this.invalidated_;
    }

    public void close() throws SQLException {
        this.myConn_.removeConnectionEventListener(this);
        this.myConn_.close();
    }

    public void setStatementTimeout(int n) {
        this.statementTimeout_ = n;
    }

    public int getStatementTimeout() {
        return this.statementTimeout_;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (!this.listeners_.contains(connectionEventListener)) {
            this.listeners_.addElement(connectionEventListener);
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners_.removeElement(connectionEventListener);
    }

    public void setLastUse(Date date) {
        this.lastUse_ = date;
    }

    public Date getLastUse() {
        return this.lastUse_;
    }

    public boolean isDiscarded() {
        return this.discarded_;
    }

    protected void setDiscarded() {
        this.discarded_ = true;
        this.connectionProxy_ = null;
        this.unsetResourceTransaction();
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        ResourceTransaction resourceTransaction = this.unsetResourceTransaction();
        ExternalXAPooledConnectionImp.suspendResourceTransaction(resourceTransaction);
        this.setDiscarded();
        ConnectionEvent connectionEvent2 = new ConnectionEvent(this);
        Enumeration enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            connectionEventListener.connectionClosed(connectionEvent2);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        ResourceTransaction resourceTransaction = this.unsetResourceTransaction();
        ExternalXAPooledConnectionImp.suspendResourceTransaction(resourceTransaction);
        this.setInvalidated();
        ConnectionEvent connectionEvent2 = new ConnectionEvent(this, connectionEvent.getSQLException());
        Enumeration enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            connectionEventListener.connectionErrorOccurred(connectionEvent2);
        }
    }

    public Connection getConnection(HeuristicMessage heuristicMessage) throws SQLException {
        this.msg_ = heuristicMessage;
        this.discarded_ = false;
        if (this.connectionProxy_ == null) {
            this.connectionProxy_ = (Connection)ConnectionProxy.newInstance(this, this.myConn_.getConnection(), this.resource_);
        }
        return this.connectionProxy_;
    }

    public boolean isInResourceTransaction() {
        return this.restx_ != null;
    }
}

