/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.ExternalXAPooledConnectionImp;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;

public class ExclusiveExternalXAPooledConnectionImp
extends ExternalXAPooledConnectionImp
implements Synchronization {
    private boolean afterCompletionDone_ = false;

    public ExclusiveExternalXAPooledConnectionImp(XAConnection xAConnection, TransactionalResource transactionalResource) {
        super(xAConnection, transactionalResource);
    }

    public ExclusiveExternalXAPooledConnectionImp(XAConnection xAConnection, TransactionalResource transactionalResource, PrintWriter printWriter) {
        super(xAConnection, transactionalResource, printWriter);
    }

    public synchronized void setResourceTransaction(ResourceTransaction resourceTransaction) throws SQLException {
        super.setResourceTransaction(resourceTransaction);
        try {
            CompositeTransaction compositeTransaction = Configuration.getCompositeTransactionManager().getCompositeTransaction();
            compositeTransaction.registerSynchronization((Synchronization)this);
            this.afterCompletionDone_ = false;
        }
        catch (Exception exception) {
            throw new AtomikosSQLException(exception);
        }
    }

    public void beforeCompletion() {
        this.afterCompletionDone_ = false;
    }

    public void afterCompletion(Object object) {
        if (this.afterCompletionDone_) {
            return;
        }
        if (object.equals(TxState.TERMINATED) || object.equals(TxState.HEUR_MIXED) || object.equals(TxState.HEUR_HAZARD) || object.equals(TxState.HEUR_ABORTED) || object.equals(TxState.HEUR_COMMITTED)) {
            this.setDiscarded();
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Enumeration enumeration = this.listeners_.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
                connectionEventListener.connectionClosed(connectionEvent);
            }
            this.afterCompletionDone_ = true;
        }
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        ResourceTransaction resourceTransaction = this.unsetResourceTransaction();
        if (resourceTransaction != null) {
            ExclusiveExternalXAPooledConnectionImp.suspendResourceTransaction(resourceTransaction);
        } else {
            this.setDiscarded();
            ConnectionEvent connectionEvent2 = new ConnectionEvent(this);
            Enumeration enumeration = this.listeners_.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
                connectionEventListener.connectionClosed(connectionEvent2);
            }
        }
    }
}

