/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.OraXidFactory;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.jdbc.DataSourceShutdownHook;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.JtaDataSourceImp;
import com.atomikos.jdbc.XAConnectionFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.XADataSource;

public class DataSourceBean
implements HeuristicDataSource,
Serializable,
Referenceable {
    private transient JtaDataSourceImp ds_ = null;
    private XADataSource xads_ = null;
    private String xadsJndiName_ = "";
    private String resourceName_ = "someUniqueName";
    private String xidFactory_ = "Default";
    private int poolSize_ = 2;
    private int connectionTimeout_ = 30;
    private int statementTimeout_ = 30;
    private boolean exclusive_ = false;
    private String validatingQuery_ = "";

    private synchronized void checkSetup(boolean bl) throws SQLException {
        Object object;
        Object object2;
        this.ds_ = JtaDataSourceImp.getInstance(this.getUniqueResourceName());
        if (this.ds_ != null && !bl) {
            return;
        }
        if (this.xads_ == null && this.getDataSourceName().equals("")) {
            throw new SQLException("DataSourceBean: xaDataSource not set.");
        }
        if (this.xidFactory_ == null) {
            throw new SQLException("DataSourceBean: xidFormat not set.");
        }
        if (!bl && !this.getDataSourceName().equals("")) {
            try {
                object2 = new InitialContext();
                object = (Context)object2.lookup("java:comp/env");
                this.xads_ = (XADataSource)object.lookup(this.getDataSourceName());
            }
            catch (Exception exception) {
                throw new SQLException("DataSourceBean: setup error: " + exception.getClass().getName() + " " + exception.getMessage());
            }
        }
        object2 = null;
        object2 = this.xidFactory_.equals("Default") ? new DefaultXidFactory() : new OraXidFactory();
        object = new XAConnectionFactory(this.resourceName_, "", "", this.xads_, (XidFactory)object2);
        ((XAConnectionFactory)object).setExclusive(this.exclusive_);
        this.ds_ = new JtaDataSourceImp((XAConnectionFactory)object, this.poolSize_, this.connectionTimeout_, this.statementTimeout_, bl, !bl);
        DataSourceShutdownHook dataSourceShutdownHook = new DataSourceShutdownHook(this.ds_);
        Runtime.getRuntime().addShutdownHook(dataSourceShutdownHook);
    }

    private synchronized void checkSetup() throws SQLException {
        this.checkSetup(false);
    }

    public void setDataSourceName(String string) {
        this.xadsJndiName_ = string;
    }

    public String getDataSourceName() {
        return this.xadsJndiName_;
    }

    public void setXaDataSource(XADataSource xADataSource) {
        this.xads_ = xADataSource;
    }

    public XADataSource getXaDataSource() {
        return this.xads_;
    }

    public void setUniqueResourceName(String string) {
        this.resourceName_ = string;
    }

    public String getUniqueResourceName() {
        return this.resourceName_;
    }

    public void setXidFormat(String string) {
        this.xidFactory_ = string;
    }

    public String getXidFormat() {
        return this.xidFactory_;
    }

    public void setConnectionPoolSize(String string) {
        this.poolSize_ = Integer.parseInt(string);
    }

    public String getConnectionPoolSize() {
        return "" + this.poolSize_;
    }

    public void setConnectionTimeout(String string) {
        this.connectionTimeout_ = Integer.parseInt(string);
    }

    public String getConnectionTimeout() {
        return "" + this.connectionTimeout_;
    }

    public void setStatementTimeout(String string) {
        this.statementTimeout_ = Integer.parseInt(string);
    }

    public String getStatementTimeout() {
        return "" + this.statementTimeout_;
    }

    public void setExclusiveConnectionMode(String string) {
        this.exclusive_ = string.equals("true");
    }

    public String isExclusiveConnectionMode() {
        return "" + this.exclusive_;
    }

    public TransactionalResource getTransactionalResource() {
        try {
            this.checkSetup();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new RuntimeException(sQLException.getMessage());
        }
        return this.ds_.getTransactionalResource();
    }

    public void setValidatingQuery(String string) {
        this.validatingQuery_ = string;
    }

    public String getValidatingQuery() {
        return this.validatingQuery_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws SQLException {
        this.checkSetup(true);
        String string = this.getValidatingQuery();
        if (string == null || string.equals("")) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.ds_.getConnection();
            try {
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                statement.close();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string, string2);
    }

    public Connection getConnection(HeuristicMessage heuristicMessage) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(heuristicMessage);
    }

    public Connection getConnection(String string) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string);
    }

    public Connection getConnection(String string, String string2, String string3) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string, string2, string3);
    }

    public Connection getConnection(String string, String string2, HeuristicMessage heuristicMessage) throws SQLException {
        this.checkSetup();
        return this.ds_.getConnection(string, string2, heuristicMessage);
    }

    public int getLoginTimeout() throws SQLException {
        this.checkSetup();
        return this.ds_.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        this.checkSetup();
        return this.ds_.getLogWriter();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.checkSetup();
        this.ds_.setLoginTimeout(n);
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.checkSetup();
        this.ds_.setLogWriter(printWriter);
    }

    public void close() throws SQLException {
        this.checkSetup();
        this.ds_.close();
    }

    public Reference getReference() throws NamingException {
        return JtaDataSourceImp.createReference(this.getUniqueResourceName());
    }
}

