/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.ConnectionFactory;
import com.atomikos.jdbc.XPooledConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.PooledConnection;

public class ConnectionPool
implements Runnable {
    private static final int DEFAULT_SIZE = 5;
    private static final int DEFAULT_TIMEOUT = 30;
    private long timeout_;
    private Vector pool_;
    private int maxSize_;
    private ConnectionFactory source_;
    private boolean timerNeeded_ = true;
    private Vector listeners_;

    public ConnectionPool(ConnectionFactory connectionFactory) throws SQLException {
        this(5, connectionFactory, 30);
    }

    public ConnectionPool(int n, ConnectionFactory connectionFactory, int n2) throws SQLException {
        this.timeout_ = n2 * 1000;
        this.source_ = connectionFactory;
        this.pool_ = new Vector();
        this.listeners_ = new Vector();
        this.maxSize_ = n;
        for (int i = 0; i < this.maxSize_; ++i) {
            XPooledConnection xPooledConnection = this.source_.getPooledConnection();
            if (xPooledConnection == null) {
                throw new SQLException("ConnectionPool constructor: null PooledConnection");
            }
            this.pool_.addElement(xPooledConnection);
            xPooledConnection.setStatementTimeout(0);
        }
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public ConnectionPool(int n, ConnectionFactory connectionFactory, int n2, int n3) throws SQLException {
        this.timeout_ = n2 * 1000;
        this.source_ = connectionFactory;
        this.pool_ = new Vector();
        this.listeners_ = new Vector();
        this.maxSize_ = n;
        for (int i = 0; i < this.maxSize_; ++i) {
            XPooledConnection xPooledConnection = this.source_.getPooledConnection();
            if (xPooledConnection == null) {
                throw new SQLException("ConnectionPool constructor: null PooledConnection");
            }
            this.pool_.addElement(xPooledConnection);
            xPooledConnection.setStatementTimeout(n3);
        }
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public int getSize() {
        return this.pool_.size();
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        XPooledConnection xPooledConnection;
        if (this.pool_.isEmpty()) {
            XPooledConnection xPooledConnection2 = this.source_.getPooledConnection();
            this.putInPool(xPooledConnection2);
            Configuration.logWarning((String)("JDBC ConnectionPool exhausted - allocated new connection: " + ((Object)xPooledConnection2).toString()));
        }
        if (!this.pool_.removeElement(xPooledConnection = (XPooledConnection)this.pool_.firstElement())) {
            throw new SQLException("Unable to take connection out of pool?");
        }
        Configuration.logDebug((String)("JDBC ConnectionPool: using connection: " + xPooledConnection));
        return xPooledConnection;
    }

    protected synchronized void putInPool(PooledConnection pooledConnection) {
        this.pool_.addElement(pooledConnection);
        this.notifyAll();
    }

    public synchronized void putBack(XPooledConnection xPooledConnection) {
        if (!xPooledConnection.getInvalidated() && this.getSize() < this.maxSize_) {
            Configuration.logDebug((String)("Putting connection back in pool: " + ((Object)xPooledConnection).toString()));
            this.putInPool(xPooledConnection);
        } else {
            try {
                Configuration.logDebug((String)("Pool: closing connection: " + ((Object)xPooledConnection).toString()));
                xPooledConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected synchronized Enumeration getOldConnections() {
        Vector<XPooledConnection> vector = new Vector<XPooledConnection>();
        Date date = new Date();
        Enumeration enumeration = this.pool_.elements();
        while (enumeration.hasMoreElements()) {
            XPooledConnection xPooledConnection = (XPooledConnection)enumeration.nextElement();
            if (date.getTime() - xPooledConnection.getLastUse().getTime() <= this.timeout_) continue;
            vector.addElement(xPooledConnection);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.pool_.removeElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public void run() {
        try {
            while (this.timerNeeded_) {
                Thread.sleep(this.timeout_);
                Enumeration enumeration = this.getOldConnections();
                while (this.timerNeeded_ && enumeration.hasMoreElements()) {
                    XPooledConnection xPooledConnection = (XPooledConnection)enumeration.nextElement();
                    Connection connection = xPooledConnection.getConnection();
                    try {
                        if (!xPooledConnection.getInvalidated()) {
                            connection.getMetaData();
                            connection.close();
                            this.putInPool(xPooledConnection);
                            continue;
                        }
                        if (this.getSize() >= this.maxSize_) continue;
                        XPooledConnection xPooledConnection2 = this.source_.getPooledConnection();
                        this.putInPool(xPooledConnection2);
                        Configuration.logDebug((String)("ConnectionPool: replacing invalidated connection " + ((Object)xPooledConnection).toString()));
                    }
                    catch (SQLException sQLException) {
                        if (this.getSize() >= this.maxSize_) continue;
                        XPooledConnection xPooledConnection3 = this.source_.getPooledConnection();
                        this.putInPool(xPooledConnection3);
                        Configuration.logDebug((String)("ConnectionPool: replacing invalidated connection " + ((Object)xPooledConnection).toString()));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void cleanup() {
        this.timerNeeded_ = false;
        if (this.pool_ == null) {
            return;
        }
        Enumeration enumeration = this.pool_.elements();
        try {
            while (enumeration.hasMoreElements()) {
                PooledConnection pooledConnection = (PooledConnection)enumeration.nextElement();
                pooledConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.pool_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.source_.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.source_.setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.source_.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return this.source_.getLoginTimeout();
    }
}

