/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.standalone;

import com.atomikos.diagnostics.Console;
import com.atomikos.diagnostics.RotatingFileConsole;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.imp.LocalLogAdministrator;
import com.atomikos.icatch.config.TSInitInfo;
import com.atomikos.icatch.config.TSMetaData;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.imp.AbstractUserTransactionService;
import com.atomikos.icatch.config.imp.TSInitInfoImp;
import com.atomikos.icatch.config.imp.TSMetaDataImp;
import com.atomikos.icatch.imp.BaseTransactionManager;
import com.atomikos.icatch.jta.AbstractJtaUserTransactionService;
import com.atomikos.icatch.jta.J2eeUserTransaction;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.jta.UserTransactionServerImp;
import com.atomikos.icatch.standalone.ExportingTransactionManagerImp;
import com.atomikos.icatch.standalone.ImportingTransactionManagerImp;
import com.atomikos.icatch.standalone.StandAloneTransactionManager;
import com.atomikos.icatch.standalone.UserTransactionServiceFactory;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.persistence.LogStream;
import com.atomikos.persistence.ObjectLog;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.persistence.imp.FileLogStream;
import com.atomikos.persistence.imp.StateRecoveryManagerImp;
import com.atomikos.persistence.imp.StreamObjectLog;
import com.atomikos.persistence.imp.VolatileStateRecoveryManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import javax.transaction.UserTransaction;

class UserTransactionServiceImp
extends AbstractJtaUserTransactionService {
    private static final String PRODUCT_NAME = "TransactionsEssentials";
    private static final String VERSION = "3.2.0";
    private File lockfile_ = null;
    private TSInitInfo info_ = null;
    private Properties properties_ = UserTransactionServiceImp.getDefaultProperties();

    UserTransactionServiceImp(Properties properties) {
        String string;
        Object object;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = properties.getProperty((String)object);
            this.properties_.setProperty((String)object, string);
        }
        if (System.getProperty("com.atomikos.icatch.no_file") != null) {
            enumeration = this.properties_.propertyNames();
            object = new Stack();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                ((Stack)object).push(string);
            }
            while (!((Stack)object).empty()) {
                string = (String)((Stack)object).pop();
                if (System.getProperty(string) == null) continue;
                this.properties_.setProperty(string, System.getProperty(string));
            }
        }
    }

    private Properties getProperties() {
        return this.properties_;
    }

    private StandAloneTransactionManager createDefault(Properties properties) throws IOException, FileNotFoundException {
        StandAloneTransactionManager standAloneTransactionManager = null;
        String string = AbstractUserTransactionService.getTrimmedProperty((String)"com.atomikos.icatch.output_dir", (Properties)properties);
        string = UserTransactionServiceImp.findOrCreateFolder((String)string);
        String string2 = string + UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.console_file_name", (Properties)properties);
        String string3 = UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.console_file_limit", (Properties)properties);
        String string4 = UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.console_file_count", (Properties)properties);
        int n = Integer.parseInt(string3);
        int n2 = Integer.parseInt(string4);
        RotatingFileConsole rotatingFileConsole = new RotatingFileConsole(string2, n, n2);
        String string5 = UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.console_log_level", (Properties)properties);
        int n3 = 1;
        if ("INFO".equals(string5)) {
            n3 = 2;
        } else if ("DEBUG".equals(string5)) {
            n3 = 3;
        }
        rotatingFileConsole.setLevel(n3);
        Configuration.addConsole((Console)rotatingFileConsole);
        String string6 = UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.log_base_name", (Properties)properties);
        String string7 = UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.log_base_dir", (Properties)properties);
        string7 = UserTransactionServiceImp.findOrCreateFolder((String)string7);
        String string8 = UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.enable_logging", (Properties)properties);
        boolean bl = true;
        if ("false".equals(string8)) {
            bl = false;
        }
        this.lockfile_ = new File(string7 + string6 + ".lck");
        if (bl && !this.lockfile_.createNewFile()) {
            System.err.println("ERROR: the specified log seems to be in use already. Make sure that no other instance is running, and then delete the file " + string7 + string6 + ".lck");
            throw new RuntimeException("Log already in use?");
        }
        this.lockfile_.deleteOnExit();
        int n4 = new Integer(UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.max_actives", (Properties)properties));
        long l = new Long(UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.checkpoint_interval", (Properties)properties));
        FileLogStream fileLogStream = new FileLogStream(string7, string6, (Console)rotatingFileConsole);
        StreamObjectLog streamObjectLog = new StreamObjectLog((LogStream)fileLogStream, l, (Console)rotatingFileConsole);
        Object object = null;
        object = bl ? new StateRecoveryManagerImp((ObjectLog)streamObjectLog) : new VolatileStateRecoveryManager();
        long l2 = new Long(UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.max_timeout", (Properties)properties));
        String string9 = UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.tm_unique_name", (Properties)properties);
        if (string9 == null || string9.equals("")) {
            throw new SysException("Property not set: com.atomikos.icatch.tm_unique_name");
        }
        standAloneTransactionManager = new StandAloneTransactionManager(string9, (StateRecoveryManager)object, (Console)rotatingFileConsole, string, l2, n4);
        if (new Boolean(UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.serial_jta_transactions", (Properties)properties)).booleanValue()) {
            TransactionManagerImp.setDefaultSerial(true);
        }
        return standAloneTransactionManager;
    }

    public void init(TSInitInfo tSInitInfo) throws SysException {
        this.info_ = tSInitInfo;
        Properties properties = tSInitInfo.getProperties();
        StandAloneTransactionManager standAloneTransactionManager = null;
        try {
            Object object;
            standAloneTransactionManager = this.createDefault(properties);
            standAloneTransactionManager.init(tSInitInfo.getProperties());
            Configuration.installCompositeTransactionManager((CompositeTransactionManager)standAloneTransactionManager);
            Configuration.installRecoveryService((RecoveryService)standAloneTransactionManager.getTransactionService());
            Configuration.installImportingTransactionManager((ImportingTransactionManager)new ImportingTransactionManagerImp((TransactionService)standAloneTransactionManager.getTransactionService()));
            Configuration.installExportingTransactionManager((ExportingTransactionManager)new ExportingTransactionManagerImp());
            Configuration.installLogControl((LogControl)standAloneTransactionManager.getTransactionService().getLogControl());
            Configuration.installTransactionService((TransactionService)standAloneTransactionManager.getTransactionService());
            String string = UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.automatic_resource_registration", (Properties)properties);
            if (string != null) {
                string = string.trim();
            }
            boolean bl = "true".equals(string);
            TransactionManagerImp.installTransactionManager((CompositeTransactionManager)standAloneTransactionManager, bl);
            Enumeration enumeration = this.info_.getLogAdministrators();
            while (enumeration.hasMoreElements()) {
                LogAdministrator logAdministrator = (LogAdministrator)enumeration.nextElement();
                if (!(logAdministrator instanceof LocalLogAdministrator)) continue;
                object = (LocalLogAdministrator)logAdministrator;
                object.init((UserTransactionService)this);
            }
            boolean bl2 = new Boolean(UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.client_demarcation", (Properties)properties));
            if (bl2) {
                object = UserTransactionServiceImp.getTrimmedProperty((String)"com.atomikos.icatch.tm_unique_name", (Properties)properties);
                if (object == null || ((String)object).equals("")) {
                    throw new SysException("Property not set: com.atomikos.icatch.tm_unique_name");
                }
                UserTransactionServerImp userTransactionServerImp = UserTransactionServerImp.getSingleton();
                userTransactionServerImp.init((String)object, properties);
                String string2 = UserTransactionServiceImp.getTrimmedProperty((String)"java.naming.factory.initial", (Properties)properties);
                String string3 = UserTransactionServiceImp.getTrimmedProperty((String)"java.naming.provider.url", (Properties)properties);
                if (string3 == null || string3.equals("")) {
                    throw new SysException("Property not set: java.naming.provider.url");
                }
            }
            super.init(tSInitInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Stack<Exception> stack = new Stack<Exception>();
            stack.push(exception);
            throw new SysException("Error in init(): " + exception.getMessage(), stack);
        }
    }

    public void shutdown(boolean bl) throws IllegalStateException {
        BaseTransactionManager baseTransactionManager = (BaseTransactionManager)Configuration.getCompositeTransactionManager();
        if (baseTransactionManager == null) {
            return;
        }
        baseTransactionManager.shutdown(bl);
        baseTransactionManager = null;
        super.shutdown(bl);
        if (this.lockfile_ != null) {
            this.lockfile_.delete();
            this.lockfile_ = null;
        }
        this.info_ = null;
    }

    public ImportingTransactionManager getImportingTransactionManager() {
        return null;
    }

    public ExportingTransactionManager getExportingTransactionManager() {
        return null;
    }

    public TSInitInfo createTSInitInfo() {
        TSInitInfoImp tSInitInfoImp = new TSInitInfoImp();
        tSInitInfoImp.setProperties(this.getProperties());
        return tSInitInfoImp;
    }

    public TSMetaData getTSMetaData() {
        return new TSMetaDataImp("1.0.1", VERSION, PRODUCT_NAME, false, false);
    }

    public UserTransaction getUserTransaction() {
        UserTransaction userTransaction = null;
        userTransaction = UserTransactionServerImp.getSingleton().getUserTransaction();
        if (userTransaction == null) {
            userTransaction = new J2eeUserTransaction();
        }
        return userTransaction;
    }

    public static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("com.atomikos.icatch.console_file_name", "tm.out");
        properties.setProperty("com.atomikos.icatch.output_dir", "." + File.separator);
        properties.setProperty("com.atomikos.icatch.log_base_dir", "." + File.separator);
        properties.setProperty("com.atomikos.icatch.log_base_name", "tmlog");
        properties.setProperty("com.atomikos.icatch.max_actives", "50");
        properties.setProperty("com.atomikos.icatch.max_timeout", "300000");
        properties.setProperty("com.atomikos.icatch.checkpoint_interval", "500");
        properties.setProperty("com.atomikos.icatch.serial_jta_transactions", "true");
        properties.setProperty("com.atomikos.icatch.tm_unique_name", UserTransactionServiceFactory.getDefaultName());
        properties.setProperty("com.atomikos.icatch.client_demarcation", "false");
        properties.setProperty("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        properties.setProperty("com.atomikos.icatch.console_log_level", "WARN");
        properties.setProperty("java.naming.provider.url", "rmi://localhost:1099");
        properties.setProperty("com.atomikos.icatch.automatic_resource_registration", "true");
        properties.setProperty("com.atomikos.icatch.enable_logging", "true");
        properties.setProperty("com.atomikos.icatch.console_file_limit", "-1");
        properties.setProperty("com.atomikos.icatch.console_file_count", "1");
        properties.setProperty("com.atomikos.icatch.soap_commit_protocols", "atomikos,wsat");
        properties.setProperty("com.atomikos.icatch.soap_request_threads", "1");
        properties.setProperty("com.atomikos.icatch.soap_host_address", UserTransactionServiceImp.getHostAddress());
        properties.setProperty("com.atomikos.icatch.soap_port", "8088");
        return properties;
    }
}

