/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.config.TSInitInfo;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.UserTransactionServiceImp;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.util.SerializableObjectFactory;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class UserTransactionManager
implements TransactionManager,
Serializable,
Referenceable {
    private transient TransactionManagerImp tm;
    private UserTransactionService uts;
    private boolean forceShutdown;
    private boolean startupTransactionService = true;
    static /* synthetic */ Class class$com$atomikos$icatch$jta$TransactionManagerImp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSetup() throws SystemException {
        Class clazz = class$com$atomikos$icatch$jta$TransactionManagerImp == null ? (class$com$atomikos$icatch$jta$TransactionManagerImp = UserTransactionManager.class$("com.atomikos.icatch.jta.TransactionManagerImp")) : class$com$atomikos$icatch$jta$TransactionManagerImp;
        synchronized (clazz) {
            this.tm = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
            if (this.tm == null) {
                if (this.getStartupTransactionService()) {
                    this.uts = new UserTransactionServiceImp();
                    TSInitInfo tSInitInfo = this.uts.createTSInitInfo();
                    this.uts.init(tSInitInfo);
                    this.tm = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
                } else {
                    throw new SystemException("Transaction service not running");
                }
            }
        }
    }

    public void setStartupTransactionService(boolean bl) {
        this.startupTransactionService = bl;
    }

    public boolean getStartupTransactionService() {
        return this.startupTransactionService;
    }

    public void init() throws SystemException {
        this.checkSetup();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.checkSetup();
        this.tm.begin();
    }

    public boolean getForceShutdown() {
        return this.forceShutdown;
    }

    public void setForceShutdown(boolean bl) {
        this.forceShutdown = bl;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.commit();
    }

    public int getStatus() throws SystemException {
        this.checkSetup();
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        this.checkSetup();
        return this.tm.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.resume(transaction);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.checkSetup();
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int n) throws SystemException {
        this.checkSetup();
        this.tm.setTransactionTimeout(n);
    }

    public Transaction suspend() throws SystemException {
        this.checkSetup();
        return this.tm.suspend();
    }

    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }

    public void close() {
        if (this.uts != null) {
            this.uts.shutdown(this.forceShutdown);
            this.uts = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

