/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentRegistrar;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.config.AbstractSpecificationExecutor;
import org.springframework.context.config.SpecificationContext;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.config.TxAnnotationDriven;
import org.springframework.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TxAnnotationDrivenExecutor
extends AbstractSpecificationExecutor<TxAnnotationDriven> {
    public static final String TRANSACTION_ADVISOR_BEAN_NAME = "org.springframework.transaction.config.internalTransactionAdvisor";
    public static final String TRANSACTION_ASPECT_BEAN_NAME = "org.springframework.transaction.config.internalTransactionAspect";
    private static final String TRANSACTION_ASPECT_CLASS_NAME = "org.springframework.transaction.aspectj.AnnotationTransactionAspect";

    TxAnnotationDrivenExecutor() {
    }

    protected void doExecute(TxAnnotationDriven txSpec, SpecificationContext specificationContext) {
        BeanDefinitionRegistry registry = specificationContext.getRegistry();
        ComponentRegistrar registrar = specificationContext.getRegistrar();
        switch (txSpec.mode()) {
            case ASPECTJ: {
                this.registerTransactionAspect(txSpec, registry, registrar);
                break;
            }
            case PROXY: {
                AopAutoProxyConfigurer.configureAutoProxyCreator(txSpec, registry, registrar);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("AdviceMode %s is not supported", txSpec.mode()));
            }
        }
    }

    private void registerTransactionAspect(TxAnnotationDriven spec, BeanDefinitionRegistry registry, ComponentRegistrar registrar) {
        if (!registry.containsBeanDefinition(TRANSACTION_ASPECT_BEAN_NAME)) {
            RootBeanDefinition def = new RootBeanDefinition();
            def.setBeanClassName(TRANSACTION_ASPECT_CLASS_NAME);
            def.setFactoryMethodName("aspectOf");
            TxAnnotationDrivenExecutor.registerTransactionManager(spec, (BeanDefinition)def);
            registrar.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, TRANSACTION_ASPECT_BEAN_NAME));
        }
    }

    private static void registerTransactionManager(TxAnnotationDriven spec, BeanDefinition def) {
        Object txManager = spec.transactionManager();
        Assert.notNull((Object)txManager, (String)"transactionManager must be specified");
        if (txManager instanceof String) {
            def.getPropertyValues().add("transactionManagerBeanName", txManager);
        } else {
            def.getPropertyValues().add("transactionManager", txManager);
        }
    }

    private static class AopAutoProxyConfigurer {
        private AopAutoProxyConfigurer() {
        }

        public static void configureAutoProxyCreator(TxAnnotationDriven txSpec, BeanDefinitionRegistry registry, ComponentRegistrar registrar) {
            Object source = txSpec.source();
            AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)registry, (ComponentRegistrar)registrar, (Object)source, (Boolean)txSpec.proxyTargetClass());
            if (!registry.containsBeanDefinition(TxAnnotationDrivenExecutor.TRANSACTION_ADVISOR_BEAN_NAME)) {
                RootBeanDefinition sourceDef = new RootBeanDefinition(AnnotationTransactionAttributeSource.class);
                sourceDef.setSource(source);
                sourceDef.setRole(2);
                String sourceName = registrar.registerWithGeneratedName((BeanDefinition)sourceDef);
                RootBeanDefinition interceptorDef = new RootBeanDefinition(TransactionInterceptor.class);
                interceptorDef.setSource(source);
                interceptorDef.setRole(2);
                TxAnnotationDrivenExecutor.registerTransactionManager(txSpec, (BeanDefinition)interceptorDef);
                interceptorDef.getPropertyValues().add("transactionAttributeSource", (Object)new RuntimeBeanReference(sourceName));
                String interceptorName = registrar.registerWithGeneratedName((BeanDefinition)interceptorDef);
                RootBeanDefinition advisorDef = new RootBeanDefinition(BeanFactoryTransactionAttributeSourceAdvisor.class);
                advisorDef.setSource(source);
                advisorDef.setRole(2);
                advisorDef.getPropertyValues().add("transactionAttributeSource", (Object)new RuntimeBeanReference(sourceName));
                advisorDef.getPropertyValues().add("adviceBeanName", (Object)interceptorName);
                if (txSpec.order() != null) {
                    advisorDef.getPropertyValues().add("order", txSpec.order());
                }
                registry.registerBeanDefinition(TxAnnotationDrivenExecutor.TRANSACTION_ADVISOR_BEAN_NAME, (BeanDefinition)advisorDef);
                CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(txSpec.sourceName(), source);
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)sourceDef, sourceName));
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)interceptorDef, interceptorName));
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)advisorDef, TxAnnotationDrivenExecutor.TRANSACTION_ADVISOR_BEAN_NAME));
                registrar.registerComponent((ComponentDefinition)compositeDef);
            }
        }
    }
}

