/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapToMapConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public MapToMapConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Map.class, Map.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        TypeDescriptor sourceKeyType = sourceType.getMapKeyTypeDescriptor();
        TypeDescriptor targetKeyType = targetType.getMapKeyTypeDescriptor();
        TypeDescriptor sourceValueType = sourceType.getMapValueTypeDescriptor();
        TypeDescriptor targetValueType = targetType.getMapValueTypeDescriptor();
        if (Object.class.equals(sourceKeyType.getType()) && Object.class.equals(sourceValueType.getType()) || Object.class.equals(targetKeyType.getType()) && Object.class.equals(targetValueType.getType())) {
            return true;
        }
        return this.conversionService.canConvert(sourceType.getMapKeyTypeDescriptor(), targetType.getMapKeyTypeDescriptor()) && this.conversionService.canConvert(sourceType.getMapValueTypeDescriptor(), targetType.getMapValueTypeDescriptor());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        Map sourceMap = (Map)source;
        Map targetMap = CollectionFactory.createMap(targetType.getType(), sourceMap.size());
        Iterator iterator = sourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry sourceMapEntry = entry = iterator.next();
            Object sourceKey = sourceMapEntry.getKey();
            Object sourceValue = sourceMapEntry.getValue();
            Object targetKey = this.conversionService.convert(sourceKey, sourceType.getMapKeyTypeDescriptor().applyIndexedObject(sourceKey), targetType.getMapKeyTypeDescriptor());
            Object targetValue = this.conversionService.convert(sourceValue, sourceType.getMapValueTypeDescriptor().applyIndexedObject(sourceValue), targetType.getMapValueTypeDescriptor());
            targetMap.put(targetKey, targetValue);
        }
        return targetMap;
    }
}

